"""Button entities for Navien Smart integration."""

import logging

from homeassistant.components.button import ButtonEntity
from homeassistant.config_entries import ConfigEntry
from homeassistant.core import HomeAssistant
from homeassistant.helpers.entity_platform import AddEntitiesCallback

from .const import DOMAIN
from .coordinator import NavienCoordinator

_LOGGER = logging.getLogger(__name__)


async def async_setup_entry(
    hass: HomeAssistant,
    entry: ConfigEntry,
    async_add_entities: AddEntitiesCallback,
) -> None:
    """Set up Navien Smart button entities."""
    coordinator: NavienCoordinator = hass.data[DOMAIN][entry.entry_id]
    async_add_entities([NavienRefreshButton(coordinator)])


class NavienRefreshButton(ButtonEntity):
    """Button to manually refresh device list and status."""

    _attr_has_entity_name = True
    _attr_name = "Refresh Devices"
    _attr_icon = "mdi:refresh"

    def __init__(self, coordinator: NavienCoordinator) -> None:
        self.coordinator = coordinator
        self._attr_unique_id = f"navien_{coordinator.api.home_seq}_refresh"
        self._attr_device_info = {
            "identifiers": {(DOMAIN, str(coordinator.api.home_seq))},
            "name": coordinator.api.home_nickname or "Navien Smart",
            "manufacturer": "Navien",
        }

    async def async_press(self) -> None:
        """Handle button press: refresh devices and status."""
        _LOGGER.info("Manual refresh triggered")
        await self.coordinator.async_refresh_devices()
